<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Výpis Směrový motiv Přehled</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Výpis Směrový motiv Přehled</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/>
                                    <br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@name"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@description"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="@file"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední revize:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">&#xa0; </th>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <table class="margin" width="90%">
                                    <colgroup span="5">
                                        <col width="18%"/>
                                        <col width="13%"/>
                                        <col width="25%"/>
                                        <col width="22%"/>
                                        <col width="22%"/>
                                    </colgroup>
                                    <xsl:for-each select="HorizontalAlignment[HorizontalCurveSets]">
                                        <tbody>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Název trasy:&#xa0;</th>
                                                <td align="left" colspan="3" valign="bottom">
                                                    <xsl:value-of select="@name"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Popis trasy:&#xa0;</th>
                                                <td align="left" colspan="3">
                                                    <xsl:value-of select="@description"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Styl trasy:&#xa0;</th>
                                                <td align="left" colspan="3">
                                                    <xsl:value-of select="@style"/>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th/>
                                                <th/>
                                                <th align="right" class="underline" lang="en">Staničení</th>
                                                <th align="right" class="underline" lang="en">Y<sub>s-jtsk</sub></th>
                                                <th align="right" class="underline" lang="en">X<sub>s-jtsk</sub></th>
                                            </tr>
                                            <xsl:apply-templates/>
                                            <tr>
                                                <td colspan="5">&#xa0;</td>
                                            </tr>
                                        </tbody>
                                    </xsl:for-each>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template match="CurvesetPoint[@pointType != 'PI']">
        <xsl:choose>
            <xsl:when test="@pointType = 'POB'">
                <tr>
                    <td align="left" lang="en">
                        <br/>Motiv Typ: Počáteční bod
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(GeometryPoint/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="GeometryPoint/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(GeometryPoint/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@northing))"/>
                    </td>
                </tr>
            </xsl:when>
            <xsl:when test="@pointType = 'POE'">
                <tr>
                    <td align="left" lang="en">
                        <br/>Motiv Typ: Koncový bod
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(GeometryPoint/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="GeometryPoint/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(GeometryPoint/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@northing))"/>
                    </td>
                </tr>
            </xsl:when>
            <xsl:when test="@pointType = 'CIRCLE'">
                <tr>
                    <td align="left" lang="en">
                        <br/>Motiv Typ: Oblouk
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(GeometryPoint/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="GeometryPoint/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(GeometryPoint/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="left" lang="en">
                        <br/>Prvek: Oblouk
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/Start/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/Start/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/Start/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/Start/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/Start/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/PI/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/PI/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/PI/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/PI/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/PI/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/PI/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/Center/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/Center/@name"/> )
                    </td>
                    <td/>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/Center/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/Center/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStopElement]/End/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStopElement]/End/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStopElement]/End/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStopElement]/End/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStopElement]/End/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStopElement]/End/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td colspan="5">&#xa0;</td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Poloměr:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/@radius))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Úhel:</td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/@delta))"/>
                    </td>
                    <td align="left" lang="en">
                        <xsl:if test="../../HorizontalElements/*[@elementNumber = current()/@curveSetStartElement]/@rotationDirection='cw'">Vpravo</xsl:if>
                        <xsl:if test="../../HorizontalElements/*[@elementNumber = current()/@curveSetStartElement]/@rotationDirection = 'ccw'">Vlevo</xsl:if>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Délka:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/@length))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/@curvatureDefinition = 'arc'">
                        </xsl:if>
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/@curvatureDefinition = 'chord'">
                            Délka tětivy:
                        </xsl:if>
                    </td>
                    <td align="right">
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/@curvatureDefinition = 'arc'">
                        </xsl:if>
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/@curvatureDefinition = 'chord'">
                            <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/End/station/@internalStation - ../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/Start/station/@internalStation))"/>
                        </xsl:if>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">
                        <xsl:choose>
                            <xsl:when test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/@curvatureDefinition = 'arc'">
                                Stupeň křivosti (oblouk):
                            </xsl:when>
                            <xsl:when test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/@curvatureDefinition = 'chord'">
                                Stupeň křivosti (Tětiva):
                            </xsl:when>
                            <xsl:otherwise>
                                Stupeň křivosti:
                            </xsl:otherwise>
                        </xsl:choose>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/@degreeOfCurve))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Tečna:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/@tangentLength))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Tětiva:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/@chord))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Střední pořadnice:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/@middleOrdinate))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">zo:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement]/@externalDistance))"/>
                    </td>
                </tr>
                <tr>
                    <td colspan="5">&#xa0;</td>
                </tr>
            </xsl:when>
            <xsl:when test="@pointType = 'SPIRAL CIRCLE SPIRAL'">
                <tr>
                    <td align="left" lang="en">
                        <br/>Motiv Typ: Přechodnice Oblouk Přechodnice
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(GeometryPoint/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="GeometryPoint/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(GeometryPoint/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td colspan="5">&#xa0;</td>
                </tr>
                <tr>
                    <td align="left" lang="en">
                        <br/>Prvek: <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@type"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Délka:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@length))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Úhel:</td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@thetaAngle))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Parametr:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@aConstant))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Dlouhá tečna Xm:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@longTangent))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Krátká tečna St:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@shortTangent))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Dlouhá tětiva:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@longChord))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">X:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@xs))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Y:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@ys))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">dR:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@p))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Xs:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@ks))"/>
                    </td>
                </tr>
                <tr>
                    <td colspan="5">&#xa0;</td>
                </tr>
                <tr>
                    <td align="left" lang="en">
                        <br/>Prvek: Oblouk
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Start/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Start/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Start/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Start/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Start/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/PI/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/PI/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/PI/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/PI/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/PI/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/PI/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Center/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Center/@name"/> )
                    </td>
                    <td/>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Center/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Center/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/End/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/End/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/End/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/End/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/End/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/End/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Poloměr:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@radius))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Úhel:</td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@delta))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Délka:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@length))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement+1]/@curvatureDefinition = 'arc'">
                        </xsl:if>
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement+1]/@curvatureDefinition = 'chord'">
                            Délka tětivy:
                        </xsl:if>
                    </td>
                    <td align="right">
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement+1]/@curvatureDefinition = 'arc'">
                        </xsl:if>
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement+1]/@curvatureDefinition = 'chord'">
                            <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement+1]/End/station/@internalStation - ../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement+1]/Start/station/@internalStation))"/>
                        </xsl:if>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">
                        <xsl:choose>
                            <xsl:when test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@curvatureDefinition = 'arc'">
                                Stupeň křivosti (Oblouk):
                            </xsl:when>
                            <xsl:when test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@curvatureDefinition = 'chord'">
                                Stupeň křivosti (Tětiva):
                            </xsl:when>
                            <xsl:otherwise>
                                Stupeň křivosti:
                            </xsl:otherwise>
                        </xsl:choose>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@degreeOfCurve))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Tečna:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@tangentLength))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Tětiva:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@chord))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Střední pořadnice:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@middleOrdinate))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">zo:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@externalDistance))"/>
                    </td>
                </tr>
                <tr>
                    <td colspan="5">&#xa0;</td>
                </tr>
                <tr>
                    <td align="left" lang="en">
                        <br/>Prvek: <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@type"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/PI/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/PI/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/PI/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/PI/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/PI/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/PI/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/End/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/End/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/End/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/End/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/End/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/End/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Délka:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@length))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Úhel:</td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@thetaAngle))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Parametr:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@aConstant))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Dlouhá tečna Xm:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@longTangent))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Krátká tečna St:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@shortTangent))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Dlouhá tětiva:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@longChord))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">X:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@xs))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Y:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@ys))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">dR:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@p))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Xs:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@ks))"/>
                    </td>
                </tr>
                <tr>
                    <td colspan="5">&#xa0;</td>
                </tr>
            </xsl:when>
            <xsl:when test="@pointType = 'SPIRAL CIRCLE COMPOUND-SPIRAL CIRCLE SPIRAL'">
                <tr>
                    <td align="left" lang="en">
                        <br/>Motiv Typ: Přechodnice Oblouk Přechodnice Oblouk Přechodnice
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(GeometryPoint/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="GeometryPoint/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(GeometryPoint/station/@externalStation), string(GeometryPoint/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(GeometryPoint/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td colspan="5">&#xa0;</td>
                </tr>
                <tr>
                    <td align="left" lang="en">
                        <br/>Prvek: <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@type"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/Start/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/PI/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Délka:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@length))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Úhel:</td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@thetaAngle))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Parametr:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@aConstant))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Dlouhá tečna Xm:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@longTangent))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Krátká tečna St:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@shortTangent))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Dlouhá tětiva:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@longChord))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">X:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@xs))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Y:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@ys))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">dR:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@p))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Xs:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/@ks))"/>
                    </td>
                </tr>
                <tr>
                    <td colspan="5">&#xa0;</td>
                </tr>
                <tr>
                    <td align="left" lang="en">
                        <br/>Prvek: Oblouk
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement]/End/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/PI/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/PI/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/PI/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/PI/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/PI/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/PI/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Center/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Center/@name"/> )
                    </td>
                    <td/>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Center/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Center/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Poloměr:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@radius))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Úhel:</td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@delta))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Délka:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@length))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@curvatureDefinition = 'arc'">
                        </xsl:if>
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@curvatureDefinition = 'chord'">
                            Délka tětivy:
                        </xsl:if>
                    </td>
                    <td align="right">
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@curvatureDefinition = 'arc'">
                        </xsl:if>
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@curvatureDefinition = 'chord'">
                            <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/End/station/@internalStation - ../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/Start/station/@internalStation))"/>
                        </xsl:if>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">
                        <xsl:choose>
                            <xsl:when test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@curvatureDefinition = 'arc'">
                                Stupeň křivosti (Oblouk):
                            </xsl:when>
                            <xsl:when test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@curvatureDefinition = 'chord'">
                                Stupeň křivosti (Chord):
                            </xsl:when>
                            <xsl:otherwise>
                                Stupeň křivosti:
                            </xsl:otherwise>
                        </xsl:choose>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@degreeOfCurve))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Tečna:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@tangentLength))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Tětiva:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@chord))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Střední pořadnice:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@middleOrdinate))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">zo:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 1]/@externalDistance))"/>
                    </td>
                </tr>
                <tr>
                    <td colspan="5">&#xa0;</td>
                </tr>
                <tr>
                    <td align="left" lang="en">
                        <br/>Prvek: <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@type"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/Start/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/PI/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/PI/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/PI/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/PI/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/PI/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/PI/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/End/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/End/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/End/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/End/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/End/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/End/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Délka:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@length))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Úhel:</td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@thetaAngle))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Parametr:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@aConstant))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Dlouhá tečna Xm:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@longTangent))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Krátká tečna St:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@shortTangent))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Dlouhá tětiva:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@longChord))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">X:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@xs))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Y:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@ys))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">dR:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@p))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Xs:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 2]/@ks))"/>
                    </td>
                </tr>
                <tr>
                    <td colspan="5">&#xa0;</td>
                </tr>
                <tr>
                    <td align="left" lang="en">
                        <br/>Prvek: Oblouk
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/Start/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/Start/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/Start/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/Start/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/Start/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/PI/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/PI/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/PI/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/PI/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/PI/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/PI/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/Center/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/Center/@name"/> )
                    </td>
                    <td/>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/Center/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/Center/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/End/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/End/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/End/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/End/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/End/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/End/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Poloměr:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/@radius))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Úhel:</td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/@delta))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Délka:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/@length))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement+3]/@curvatureDefinition = 'arc'">
                        </xsl:if>
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement+3]/@curvatureDefinition = 'chord'">
                            Délka tětivy:
                        </xsl:if>
                    </td>
                    <td align="right">
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement+3]/@curvatureDefinition = 'arc'">
                        </xsl:if>
                        <xsl:if test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement+3]/@curvatureDefinition = 'chord'">
                            <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement+3]/End/station/@internalStation - ../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement+3]/Start/station/@internalStation))"/>
                        </xsl:if>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">
                        <xsl:choose>
                            <xsl:when test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/@curvatureDefinition = 'arc'">
                                Stupeň křivosti (Oblouk):
                            </xsl:when>
                            <xsl:when test="../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/@curvatureDefinition = 'chord'">
                                Stupeň křivosti (Tetiva):
                            </xsl:when>
                            <xsl:otherwise>
                                Stupeň křivosti:
                            </xsl:otherwise>
                        </xsl:choose>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/@degreeOfCurve))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Tečna:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/@tangentLength))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Tětiva:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/@chord))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Střední pořadnice:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/@middleOrdinate))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">zo:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalCircle[@elementNumber = current()/@curveSetStartElement + 3]/@externalDistance))"/>
                    </td>
                </tr>
                <tr>
                    <td colspan="5">&#xa0;</td>
                </tr>
                <tr>
                    <td align="left" lang="en">
                        <br/>Prvek: <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/@type"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/Start/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/Start/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/Start/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/Start/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/Start/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/Start/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/PI/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/PI/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/PI/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/PI/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/PI/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/PI/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <xsl:value-of select="cif:pointType(string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/End/@pointType))"/>
                    </td>
                    <td align="right">
                        ( <xsl:value-of select="../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/End/@name"/> )
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:stationFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/End/station/@externalStation),
                                                                string(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/End/station/@externalStationName))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/End/@easting))"/>
                    </td>
                    <td align="right">
                        <xsl:value-of select="cif:ordinateFormat(-1*number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/End/@northing))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Délka:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/@length))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Úhel:</td>
                    <td align="right">
                        <xsl:value-of select="cif:angularFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/@thetaAngle))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Parametr:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/@aConstant))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Dlouhá tečna Xm:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/@longTangent))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Krátká tečna St:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/@shortTangent))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Dlouhá tětiva:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/@longChord))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">X:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/@xs))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Y:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/@ys))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">dR:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/@p))"/>
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2" lang="en">Xs:</td>
                    <td align="right">
                        <xsl:value-of select="cif:distanceFormat(number(../../HorizontalElements/HorizontalSpiral[@elementNumber = current()/@curveSetStartElement + 4]/@ks))"/>
                    </td>
                </tr>
            </xsl:when>
            <xsl:otherwise>
                <tr>
                    <td align="left" colspan="2" lang="en" style="color:red">*** Nepodporovaná sestava pro výpis ***</td>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musí být vybrán nejméně jeden Civil prvek směrové geometrie.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
